---
title: Increased blob size limits in Workers Analytics Engine · Changelog
description: We’ve increased the total allowed size of blob fields per request
  from 5 KB to 16 KB in the Workers Analytics Engine.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-06-20-increased-blob-size-limits-in-workers-analytics/
  md: https://developers.cloudflare.com/changelog/2025-06-20-increased-blob-size-limits-in-workers-analytics/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Increased blob size limits in Workers Analytics Engine

Jun 20, 2025

[Workers](https://developers.cloudflare.com/workers/)

We’ve increased the total allowed size of [`blob`](https://developers.cloudflare.com/analytics/analytics-engine/get-started/#2-write-data-points-from-your-worker) fields on data points written to [Workers Analytics Engine](https://developers.cloudflare.com/analytics/analytics-engine/) from **5 KB to 16 KB**.

This change gives you more flexibility when logging rich observability data — such as base64-encoded payloads, AI inference traces, or custom metadata — without hitting request size limits.

You can find full details on limits for queries, filters, payloads, and more [here in the Workers Analytics Engine limits documentation](https://developers.cloudflare.com/analytics/analytics-engine/limits/).

* JavaScript

  ```js
  export default {
    async fetch(request, env) {
      env.analyticsDataset.writeDataPoint({
        // The sum of all of the blob's sizes can now be 16 KB
        blobs: [
          // The URL of the request to the Worker
          request.url,
          // Some metadata about your application you'd like to store
          JSON.stringify(metadata),
          // The version of your Worker this datapoint was collected from
          env.versionMetadata.tag,
        ],
        indexes: ["sample-index"],
      });
    },
  };
  ```

* TypeScript

  ```ts
  export default {
    async fetch(request, env) {
      env.analyticsDataset.writeDataPoint({
        // The sum of all of the blob's sizes can now be 16 KB
        blobs: [
          // The URL of the request to the Worker
          request.url,
          // Some metadata about your application you'd like to store
          JSON.stringify(metadata),
          // The version of your Worker this datapoint was collected from
          env.versionMetadata.tag,
        ],
        indexes: ["sample-index"],
      });
    }
  };
  ```
