---
title: Clearance · Cloudflare challenges docs
description: A cf_clearance cookie proves to Cloudflare that the visitor is a
  verified human and has passed the Challenge presented to them.
lastUpdated: 2025-11-12T16:45:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/concepts/clearance/
  md: https://developers.cloudflare.com/cloudflare-challenges/concepts/clearance/index.md
---

## `cf_clearance` cookies

A `cf_clearance` cookie proves to Cloudflare that the visitor is a verified human and has passed the Challenge presented to them.

The `cf_clearance` cookie is securely tied to the specific visitor and device it was issued to. This binding is a security feature designed to prevent the cookie from being easily transferred and re-used on other machines.

As an additional layer of security, Cloudflare recommends that customers [add a rate limiting rule](https://developers.cloudflare.com/waf/rate-limiting-rules/) based on the `cf_clearance` cookie value. This ensures that a single, valid cookie cannot be abused by a single machine to send an excessive volume of requests.

If a visitor passes an Interactive Challenge (highest security level), then the `cf_clearance` cookie indicates this to the origin and allows the visitor to bypass any other Challenge on the website, whether it is another Interactive Challenge, a Managed Challenge, or a non-interactive JavaScript Challenge for as long as the cookie is valid.

If a visitor receives a `cf_clearance` cookie on a page that uses a WAF rule with Managed or JavaScript Challenge (lower security levels), then encountering a different page with a higher security clearance level Challenge will prompt them to solve the Challenge again.

The original `cf_clearance` cookie that was issued to the visitor from a lower security clearance level Challenge will be replaced with the new `cf_clearance` cookie from a higher security clearance level Challenge.

## Pre-clearance support in Turnstile

Pre-clearance in [Turnstile](https://developers.cloudflare.com/turnstile/) allows websites to streamline user experiences by using `cf_clearance` cookies. The `cf_clearance` cookie enables visitors to bypass WAF Challenges downstream, based on the security clearance level set by the customer. This can be particularly useful for trusted visitors, enhancing usability while maintaining security.

By default, Turnstile issues a one-time use token to the visitor when they solve a Challenge via the widget. The token goes to your website's backend that needs to be validated by Siteverify API.

Warning

It is critical to enforce Turnstile tokens with the Siteverify API. The Turnstile token could be invalid, expired, or already redeemed. Not verifying the token will leave major vulnerabilities in your implementation.

You **must** call Siteverify to complete your Turnstile configuration. Otherwise, it is incomplete and will result in zeroes for token validation when viewing your metrics in [Turnstile Analytics](https://developers.cloudflare.com/turnstile/turnstile-analytics/).

Note

The clearance token cannot be used again.

| Challenge type | Issued clearance |
| - | - |
| Challenge Page | `cf_clearance` cookie (default) |
| Turnstile widget | Token (default) `cf_clearance` cookie (optional addition) |

When you enable pre-clearance support on Turnstile, a `cf_clearance` cookie is issued to the visitor in addition to the default Turnstile token.

You can integrate Cloudflare Challenges by allowing Turnstile to issue a `cf_clearance` cookie as pre-clearance to your visitor. The pre-clearance level is set upon widget creation or widget modification using the Turnstile API's clearance\_level. Possible values for the configuration are:

* `interactive`
* `managed`
* `jschallenge`
* `no_clearance`

All widgets have pre-clearance mode set to `false` and the security clearance is set to `no_clearance` by default.

For Enterprise customers eligible to enable widgets without any pre-configured hostnames, Cloudflare recommends issuing pre-clearance cookies on widgets where at least one hostname is specified and is the same as the zone that you want to integrate with Turnstile.

Refer to the [blog post](https://blog.cloudflare.com/integrating-turnstile-with-the-cloudflare-waf-to-challenge-fetch-requests) for more details on how pre-clearance works with WAF.

### Pre-clearance level options

**Interactive** (High) `interactive`

Allows a user with a clearance cookie to not be challenged by Interactive, Managed Challenge, or JavaScript Challenge Firewall Rules.

**Managed** (Medium) `managed`

Allows a user with a clearance cookie to not be challenged by Managed Challenge or JavaScript Challenge Firewall Rules.

**Non-interactive** (Low) `jschallenge`

Allows a user with a clearance cookie to not be challenged by JavaScript Challenge Firewall Rules.

### Clearance cookie duration

Clearance cookies generated by the Turnstile widget will be valid for the time specified by the zone-level Challenge Passage value. To configure the Challenge Passage setting, refer to [Challenge Passage](https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/challenge-passage/).

### Setup

To enable pre-clearance, you must ensure that the hostname of the Turnstile widget matches the zone with the WAF rules. During the Turnstile configuration setup in the Cloudflare dashboard, you have access to a list of registered zones. Select the appropriate hostname from this list.

The prerequisite is crucial for pre-clearance to function properly. If set up correctly, visitors who successfully solve Turnstile will receive a cookie with the security clearance level set by the customer. When encountering a WAF challenge on the same zone, they will bypass additional challenges for the configured clearance level and below.

For more details on managing hostnames, refer to the [Hostname Management documentation](https://developers.cloudflare.com/turnstile/additional-configuration/hostname-management/).

Note

[JavaScript detections](https://developers.cloudflare.com/bots/additional-configurations/javascript-detections/) are stored in the `cf_clearance` cookie.

The `cf_clearance` cookie cannot exceed the maximum size of 4096 bytes.

#### Enable pre-clearance on a new site

1. In the Cloudflare dashboard, go to the **Turnstile** page.

   [Go to **Turnstile**](https://dash.cloudflare.com/?to=/:account/turnstile)

2. Select **Add widget**.

3. Under **Would you like to opt for pre-clearance for this site?** select **Yes**.

4. Choose the pre-clearance level from the select box.

5. Select **Create**.

#### Enable pre-clearance on an existing site

1. In the Cloudflare dashboard, go to the **Turnstile** page.

   [Go to **Turnstile**](https://dash.cloudflare.com/?to=/:account/turnstile)

2. Go to the existing widget or site and select **Settings**.

3. Under **Would you like to opt for pre-clearance for this site?** select **Yes**.

4. Choose the pre-clearance level from the select box.

5. Select **Update**.
