---
title: DDoS analytics · Cloudflare DDoS Protection docs
description: "You can view DDoS analytics in different dashboards, depending on
  your service and plan:"
lastUpdated: 2025-02-20T15:42:50.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/ddos-protection/reference/analytics/
  md: https://developers.cloudflare.com/ddos-protection/reference/analytics/index.md
---

You can view DDoS analytics in different dashboards, depending on your service and plan:

* The [Security Events dashboard](https://developers.cloudflare.com/waf/analytics/security-events/) provides you with visibility into L7 security events that target your zone, including HTTP DDoS attacks and TCP attacks. The dashboard displays mitigations of HTTP DDoS attacks as HTTP DDoS events. These events are also available via [Cloudflare Logs](https://developers.cloudflare.com/logs/).

* The [Network Analytics dashboard](https://developers.cloudflare.com/analytics/network-analytics/) provides you with visibility into L3/4 traffic and DDoS attacks that target your IP ranges or Spectrum applications.

## Availability

| Service | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| WAF/CDN | Sampled logs only | Security Events | Security Events | Security Events |
| Spectrum/BYOIP | – | – | – | Network Analytics |
| Magic Transit | – | – | – | Network Analytics |

## Remarks

In some situations, the analytics dashboards will not show you the ID of the DDoS managed rule that handled a packet/request. This means that an internal DDoS rule, which Cloudflare does not currently expose publicly, applied an action to the packet/request. These internal DDoS rules have a very low false positive rate and should always be enabled to protect your properties against DDoS attacks. For the same reason, DDoS rule IDs may also be unavailable in Cloudflare logs and API responses.
