---
title: Epochs · Cloudflare Key Transparency Auditor docs
description: Refer to the example below to publish a new epoch by requesting its signature.
lastUpdated: 2024-09-24T11:10:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/key-transparency/api/epochs/
  md: https://developers.cloudflare.com/key-transparency/api/epochs/index.md
---

## Get an epoch

```sh
curl 'https://plexi.key-transparency.cloudflare.com/namespaces/{namespace}/audits/1'
{
  "namespace": "your.new.log.com",
  "timestamp": 1717084639921,
  "epoch": 1,
  "digest": "1111111111111111111111111111111111111111111111111111111111111111",
  "signature": "f6a51443bb6703813b330959d9d97471bc06464142165e59733fa102a18b052782a5307d59c31b8b13c1af7dfff6f6e7bf44e880d44e26e96c50a72f72a30c07"
}
```

## Publish a new epoch

Refer to the example below to publish a new epoch by requesting its signature.

This API is authenticated via [mTLS](https://www.cloudflare.com/learning/access-management/what-is-mutual-tls/), so that only a Log owner can publish new epochs.

```sh
curl 'https://plexi.key-transparency.cloudflare.com/namespaces/{namespace}/audits' \
      --header 'Content-Type: application/json' \
      --data '{"epoch": 1, "digest": "1111111111111111111111111111111111111111111111111111111111111111"}'
{
  "namespace": "your.new.log.com",
  "timestamp": 1717084639921,
  "epoch": 1,
  "digest": "1111111111111111111111111111111111111111111111111111111111111111",
  "signature": "f6a51443bb6703813b330959d9d97471bc06464142165e59733fa102a18b052782a5307d59c31b8b13c1af7dfff6f6e7bf44e880d44e26e96c50a72f72a30c07",
  "key_id": 74,
}
```

### Constraints

* If `root` is defined for the namespace, the first epoch must match it (number and digest).
* Epochs must be increasing. Second epoch is 2, third is 3, etc.
* Epochs must have a unique digest or it will be rejected.
* Epochs cannot be republished.
* Digest must be a 32 byte string hex encoded (length 64).

If a namespace is disabled, you receive the following error:

```txt
HTTP 400 Bad Request
Namespace is disabled and read-only.
```
