---
title: Logpush Health Dashboards · Cloudflare Logs docs
description: Logpush Health Dashboards give you a clear view into the
  performance and reliability of your Logpush jobs. You can monitor the status
  of log delivery, diagnose issues, and understand the volume of data being sent
  to your configured destinations. This helps you ensure that critical log data
  for security, compliance, and observability is always flowing as expected.
lastUpdated: 2025-11-11T16:20:22.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/logs/logpush/logpush-health/
  md: https://developers.cloudflare.com/logs/logpush/logpush-health/index.md
---

Logpush Health Dashboards give you a clear view into the performance and reliability of your Logpush jobs. You can monitor the status of log delivery, diagnose issues, and understand the volume of data being sent to your configured destinations. This helps you ensure that critical log data for security, compliance, and observability is always flowing as expected.

***

## Access Health Dashboards

1. In the **Cloudflare dashboard**, go to the **Logpush** page at either the account or domain (zone) level.
2. Go to the **Health** tab.
3. Select the job you want to analyze.
4. Specify the time range you want to review.
5. *(Optional)* From the **Jobs** tab, locate the job you want to analyze.
6. Hover over the **Job Health (24h)** column for that job and select **View Health**.
7. You will be redirected to the **Health** tab, where you can select the desired time range for analysis.

### Data availability and API access

* The **Health Dashboard** displays up to **30 days** of health metrics for each Logpush job in the Cloudflare dashboard.
* The raw health metrics can be queried via the `logpushHealthAdaptiveGroups` dataset in the GraphQL API.
* You can explore or test queries using the [Cloudflare GraphQL Explorer](https://graphql.cloudflare.com/explorer).

## Key concepts in job health

### Log line

A single log entry generated by Cloudflare, such as an HTTP request, DNS query, or Access event.

### Batch

A group of logs that Cloudflare uploads together to your destination as a single file or request. A batch is also referred to as a file.

### Upload

A single attempt to upload a batch of logs to your destination. If the first attempt fails, Cloudflare automatically retries until the upload succeeds or the retry limit is reached. Each upload can have one of three outcomes: **Successful**, **Retry attempts**, or **Failed**.

#### Successful

Indicates that a batch of logs was uploaded to your destination without errors or timeouts. Once an upload succeeds, the batch is marked as delivered and no further retries occur.

#### Retry attempts

Additional upload attempts made after an initial failure. The count includes the first failed attempt. Retries continue until the batch is successfully delivered or the retry limit is reached.

#### Failed

Indicates that all upload attempts for a batch were exhausted without success. When a batch fails, Cloudflare cannot deliver its logs to your destination, and all logs in that batch are dropped. These logs are permanently lost.

## Health dashboard flow

The **Logpush Health Dashboard** provides two complementary views that help you monitor and troubleshoot log delivery: **Upload Health** and **Upload Reliability**.

Each view highlights a different aspect of job performance — what was delivered and how reliably it was delivered.

### Upload Health

**Upload Health** helps you understand how much data was successfully uploaded and where uploads failed or data was dropped. This view answers: Are uploads succeeding, and are logs reaching the destination?

#### Charts and metrics

* **Batch Upload Success vs. Failure**: Displays the number of batches that were successfully uploaded versus those that failed.

  * **Successful Uploads** - Total number of batches successfully uploaded.
  * **Failed Uploads** - Total number of batches that failed to upload due to connection or destination issues.

* **Log Lines Uploaded**: Tracks the total number of log lines successfully uploaded to your destination.

  * **Uploaded Log Lines** - Total number of log lines successfully delivered.
  * **Dropped Log Lines** - Total number of log lines that could not be delivered after all retry attempts.

* **Data Volume**: Shows the total volume of log data uploaded (in bytes), both compressed and uncompressed.

  * **Uncompressed Data (raw)** - Total size of log data before compression.
  * **Compressed Data (uploaded)** - Total size of log data after compression, representing the actual bytes transmitted.

#### When to use

Start here to assess overall data delivery health:

* High upload success and stable data volume indicate a healthy Logpush job.
* Drops, spikes, or failed uploads suggest delivery issues — proceed to **Upload Reliability** to investigate root causes.

### Upload Reliability

Upload Reliability helps you identify factors affecting reliability, stability, and latency across all upload attempts (including retries and failures). This view answers: Are uploads stable and efficient?

#### Charts and metrics

* **Uploaded Logs by Status Code** Shows the number of batches that were successful, failed, or retried, categorized by status code.

  * **Success Rate** - Percentage of batches successfully uploaded.
  * **Successful Uploads** - Total number of batches successfully completed.

* **Upload Duration**: Shows the average time taken to complete each batch upload, broken down by status code.

  * **Destination Availability** - How often Cloudflare successfully connected to your destination and completed uploads.
  * **Average Upload Duration** - Average time taken to upload logs after they are generated.

* **Retry Attempts**: Displays the number of retries made after failed uploads, broken down by status code.

  * **Retry Attempts** - Total number of upload attempts made after previous failures (includes the first failed attempt).

#### When to use

Use this view to troubleshoot reliability issues:

* High latency, frequent retries, or low destination availability indicate potential instability in the destination endpoint or network.
* Combine with **Upload Health** metrics to correlate delivery success with underlying reliability patterns.

## Troubleshooting guide

The Logpush Health Dashboards help you monitor the status, reliability, and performance of your Logpush jobs. Use this guide to interpret each chart, identify the root cause of anomalies, and take corrective action.

| Chart name | Symptom | What it means | Possible causes | Recommended actions |
| - | - | - | - | - |
| **Batch Upload Success vs Failure** | Failed uploads | Cloudflare could not deliver batches after all retry attempts. These batches are marked as **failed**, and all log lines in them are dropped. | - Destination endpoint unavailable or rejecting connections (expired credentials, downtime). - Uploads timing out due to large batch sizes or network latency. - Destination throttling or rate limiting. | - Verify destination credentials and endpoint health. - Reduce batch size in the Logpush job configuration. - Ensure the destination can handle the expected upload rate. - Contact Cloudflare Support if failures persist. |
| **Log Lines Uploaded** | Dropped log lines or reduced delivery volume | Fewer logs are being delivered than expected, often due to failed uploads or dropped batches. | - Spike in failed uploads. - Destination ingestion limits or partial uploads. | - Compare **Log Lines Uploaded** and **Data Volume** charts for dips. - Check destination for ingestion errors or rate limiting. - Review recent Logpush job configuration changes. |
| **Data Volume (Compressed & Uncompressed)** | Unexpected drop in data volume | Delivered data volume is lower than expected, suggesting compression inefficiencies or dropped batches. | - Failed uploads or incomplete deliveries. - Destination rejecting uploads due to size or quota limits. | - Review compression settings and batch size. - Verify destination storage capacity. - Check for spikes in failed uploads or retries. |
| **Uploaded Logs by Status Code** | High number of retries or failed status codes | Uploads fail on the first attempt but succeed on retries. | - Temporary destination downtime or throttling. - Network instability between Cloudflare and the destination. | - Review retry and failure distribution by status code. - Compare with **Destination Availability** for correlation. - Reduce batch size. |
| **Retry Attempts** | Frequent retry activity | Uploads are repeatedly failing and retried multiple times. | - Destination instability or transient errors. - High latency or slow acknowledgements from the destination. | - Verify destination uptime and ingestion rate. - Ensure destination is not throttling requests. - Occasional retries are expected; persistent spikes require review. |
| **Avg. Upload Duration** | Long upload times | Uploads are taking longer than expected, indicating latency or oversized batches. | - Large batches or uncompressed payloads. - Network or regional latency. - Destination processing delays. | - Review **Avg. Upload Duration** trends. - Reduce batch size for faster uploads. - Verify destination throughput and rate limit settings. |
| **Destination Availability** | Low or unstable availability | Cloudflare cannot consistently connect to your destination. | - Destination downtime, DNS errors, or authentication issues. - Firewall or network restrictions blocking Cloudflare. | - Check **Destination Availability** for dips. - Confirm destination credentials and endpoint uptime. - Review allowlists or network access settings. |
