---
title: Stream · Cloudflare Style Guide
description: required
lastUpdated: 2025-08-22T21:03:10.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/stream/
  md: https://developers.cloudflare.com/style-guide/components/stream/index.md
---

## Import

```mdx
import { Stream } from "~/components";
```

## Usage

```mdx
<Stream
  id="86f22d1f760b77cdc349f89b25b63c3e"
  title="Connect and secure from any network to anywhere"
  thumbnail="https://pub-d9bf66e086fb4b639107aa52105b49dd.r2.dev/Connect-and-secure-from-any-network-to-anywhere.jpg"
  chapters={{
    "Chapter 1": "30s",
    "Chapter 2": "1m30s",
    "Chapter 3": "3m15s",
    "Chapter 4": "3m25s",
    "Chapter 5": "3m35s",
  }}
/>


<Stream file="warp-1-basics" />
```

## `<Stream>` Props

### `id`

**required**

**type:** `string`

The ID of the Stream video.

### `title`

**required**

**type:** `string`

The title of the Stream video.

### `thumbnail`

**type:** `string`

Either a timestamp (i.e `2.5s` or `1m35s`) or a URL to an image.

### `chapters`

**type:** `Record<string, string>`

Optional chapters displayed as cards below the video.

### `expandChapters`

**type:** `boolean`

**default:** `false`

If `chapters` is present, is passed through to the `open` property of the [Details component](https://developers.cloudflare.com/style-guide/components/details/).

### `showMoreVideos`

**type:** `boolean`

**default:** `true`

Whether to show the "Watch more videos on our Developer Channel" link below the video.

### `file`

**type:** `string`

If `file` is provided, the `id`, `title`,` thumbnail` and `chapters` properties cannot be used and are instead retrieved from the YAML file in the [`stream`](https://github.com/cloudflare/cloudflare-docs/tree/production/src/content/stream) collection.
