---
title: Reference architecture diagram · Cloudflare Style Guide
description: To provide a visual reference and explanation of using Cloudflare
  for a specific solution.
lastUpdated: 2025-08-20T21:45:15.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture-diagram/
  md: https://developers.cloudflare.com/style-guide/documentation-content-strategy/content-types/reference-architecture-diagram/index.md
---

## Purpose

To provide a visual reference and explanation of using Cloudflare for a specific solution.

Disambiguation

This page describes the content strategy for a reference architecture diagram. For help with Cloudflare products, refer to [Reference archiectures diagrams](https://developers.cloudflare.com/reference-architecture/diagrams/).

## Tone

instructional, straightforward

## content\_type

```yaml
pcx_content_type: reference-architecture-diagram
```

For more details, refer to [`pcx_content_type`](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#pcx_content_type).

## Components

### Most used

* [`PublicStats`](https://developers.cloudflare.com/style-guide/components/public-stats/):

  The `PublicStats` component allows you to reference specific values about Cloudflare's network without maintaining those values in multiple files.

* [Diagrams](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/diagrams/): Particularly helpful for image captions.

### Required

[**Title**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/titles/): Short verb phrase in second-person imperative. Do not use gerund phrases.

[**Reference diagram**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/reference-diagram/): A single diagram that reflects the overall reference architecture.

### Optional

[**Notes/warnings**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/notes-tips-warnings/)

**Screenshots**

[**Related links**](https://developers.cloudflare.com/style-guide/documentation-content-strategy/component-attributes/links/): Bulleted list of links to associated resources.

## Template

```plaintext
# Cloudflare Reference Architecture Diagram


Provide a description as to what the diagram below contains.


![Example reference architecture diagram](/images/reference-architecture/cloudflare-one-reference-architecture-images/cf1-ref-arch-14.svg "The above is an example reference architecture diagram")


1. Call out
2. Any numbered items
3. In the diagram
4. To explain their meaning/use


Provide some context to the diagram. What it relates to and link to any supporting content.
```
