---
title: Update custom rules for customers or partners · Cloudflare Web
  Application Firewall (WAF) docs
description: You may want to adjust your custom rules to increase access by
  customers or partners.
lastUpdated: 2025-07-09T14:24:57.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/custom-rules/use-cases/update-rules-customers-partners/
  md: https://developers.cloudflare.com/waf/custom-rules/use-cases/update-rules-customers-partners/index.md
---

You may want to adjust your custom rules to increase access by customers or partners.

Potential examples include:

* Removing rate limiting for an API
* Sharing brand assets and marketing materials

Warning

The example custom rules in this page can bypass Cloudflare's security features and are generally not recommended. Use with caution.

## Use ASN in custom rules

If a customer or partner is large enough, you could set up a custom rule based on an [autonomous system number (ASN)](https://www.cloudflare.com/learning/network-layer/what-is-an-autonomous-system/).

### Allow traffic by ASN

This example uses:

* The [`ip.src.asnum`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/ip.src.asnum/) field to specify the general region.
* The [`cf.bot_management.score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.score/) field to ensure partner traffic does not come from bots.

Example custom rule:

* **Expression**: `(ip.src.asnum eq 64496 and cf.bot_management.score gt 30)`
* **Action**: *Skip:*
  * *All remaining custom rules*

Note

Access to [Bot Management](https://developers.cloudflare.com/bots/plans/bm-subscription/) requires a Cloudflare Enterprise plan with Bot Management.

### Adjust rules by ASN

This example custom rule uses:

* The [`ip.src.asnum`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/ip.src.asnum/) field to specify the general region.
* The [`cf.bot_management.score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.score/) field to check if the request comes from a human.

If a request meets these criteria, the custom rule will skip [User Agent Blocking](https://developers.cloudflare.com/waf/tools/user-agent-blocking/) rules.

* **Expression**: `(ip.src.asnum eq 64496 and cf.bot_management.score gt 50)`
* **Action**: *Skip:*
  * *User Agent Blocking*

## Use IP addresses in custom rules

For smaller organizations, you could set up custom rules based on IP addresses.

### Allow traffic by IP address

This example:

* Specifies the source IP address and the host.
* Uses the [`cf.bot_management.score`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/cf.bot_management.score/) field to ensure requests are not high-risk traffic.

Example custom rule:

* **Expression**: `(ip.src eq 203.0.113.1 and http.host eq "example.com" and cf.bot_management.score gt 30)`
* **Action**: *Skip:*
  * *All remaining custom rules*

### Adjust rules by IP address

This example custom rule specifies the source IP address and the host.

If a request meets these criteria, the custom rule will skip [rate limiting rules](https://developers.cloudflare.com/waf/rate-limiting-rules/).

* **Expression**: `(ip.src eq 203.0.113.1 and http.host eq "example.com")`
* **Action**: *Skip:*
  * *All remaining custom rules*
