---
title: Create a list in the dashboard · Cloudflare Web Application Firewall (WAF) docs
description: "To create a list, follow these steps:"
lastUpdated: 2025-09-12T15:50:27.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waf/tools/lists/create-dashboard/
  md: https://developers.cloudflare.com/waf/tools/lists/create-dashboard/index.md
---

To create a list, follow these steps:

1. In the Cloudflare dashboard, go to the **Settings** page.

   [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/configurations)

2. Go to **Lists**.

3. Select **Create new list**.

4. Enter a name for your list, observing the [list name guidelines](https://developers.cloudflare.com/waf/tools/lists/#list-names).

5. (Optional) Enter a description for the list, with a maximum length of 500 characters.

6. For **Content type**, select the [type of list](https://developers.cloudflare.com/waf/tools/lists/custom-lists/) you are creating.

7. Select **Create**.

8. Follow the instructions in the next section to add items to the list.

## Add items to a list

1. (Optional) If you wish to add items to an existing list:

   1. Go to the **Settings** page.

      [Go to **Settings**](https://dash.cloudflare.com/?to=/:account/configurations)

   2. Go to **Lists**.

   3. Select **Edit** next to the list you want to edit.

2. Select **Add items**.

3. To [add items to the list manually](#add-items-to-a-list-manually), use the available text inputs on the page.

4. To [add items using a CSV file](#add-items-using-a-csv-file), select **Upload CSV**.

Notes

Cloudflare will apply the following rules when you add items to an existing list (either manually or via CSV file):

* Do not remove any existing list items before updating/adding items.
* Update items that were already in the list.
* Add items that were not present in the list.

### Add items to a list manually

1. In the **Add items to list** page, enter values for the different fields (the exact fields depend on the list type).

   As you enter information into a text input, a new row of inputs displays below the current one. To delete any of the items that you have entered, select **X**.

2. Select **Add to list**.

### Add items using a CSV file

To add items to a list by uploading a CSV file:

1. In the **Add items to list** page, select **Upload CSV**.

2. Browse to the location of the CSV file, select the file, and then select **Open**. The displayed items in the page will include the items loaded from the CSV file.

   The exact CSV file format depends on the list type. Refer to [Custom list types](https://developers.cloudflare.com/waf/tools/lists/custom-lists/#custom-list-types) for details.

3. You can continue to edit the items in the list before adding them:

   * To delete any of the items you have entered, select **X**.
   * To add extra items manually, enter the information in the text inputs.

4. Select **Add to list**.
