---
title: Glossary · Cloudflare Waiting Room docs
description: Review the definitions for terms used across Cloudflare's Waiting
  Room documentation.
lastUpdated: 2024-08-13T19:56:56.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/waiting-room/glossary/
  md: https://developers.cloudflare.com/waiting-room/glossary/index.md
---

Review the definitions for terms used across Cloudflare's Waiting Room documentation.

| Term | Definition |
| - | - |
| downtime | Downtime is the duration during which a system, service, or equipment is not operational or unavailable for use. |
| error page | An error page is a webpage shown to users when they try to access a specific webpage or resource that is unavailable due to a server error, broken link, or other issues. It typically includes details about the encountered error and offers potential solutions or guidance to help users navigate the problem. |
| iFrame | An iFrame, short for Inline Frame, is an HTML element used to embed and display external content within a webpage, allowing the incorporation of another document or web page seamlessly within the main document. |
| JSON-friendly | JSON-friendly refers to data or formats that are easily and naturally represented in JSON (JavaScript Object Notation), a lightweight data interchange format, without requiring complex transformations or modifications. |
| legitimate traffic | Legitimate traffic refers to authorized and permissible network activity, data transmissions, or communications that adhere to established norms and rules within a given system or network. |
| non-browser traffic | Non-browser traffic refers to data exchanges and communication occurring between devices or systems that do not involve web browsers, such as a mobile app or web apps. |
| SEO crawlers | SEO crawlers, or web crawlers, are automated programs employed by search engines to systematically browse and index web content, gathering information about the structure and relevance of pages to determine search result rankings. |
| Set-Cookie | Set-Cookie is an HTTP header used by web servers to send a cookie to a user's browser during an HTTP response, enabling the server to store information on the client side, often used for session management and user preferences. |
| traffic management | The process of controlling and optimizing the flow of network data to ensure efficient and reliable communication. |
| virtual waiting room | A virtual waiting room is an online system or feature that manages and controls access to a website or service during periods of high traffic, preventing server overload by placing users in a queue until they can be accommodated, ensuring a more equitable and efficient user experience. |
