---
title: Runtime APIs · Cloudflare Workers docs
description: The Workers runtime is designed to be JavaScript standards
  compliant and web-interoperable. Wherever possible, it uses web platform APIs,
  so that code can be reused across client and server, as well as across
  WinterCG JavaScript runtimes.
lastUpdated: 2025-02-05T10:06:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/workers/runtime-apis/
  md: https://developers.cloudflare.com/workers/runtime-apis/index.md
---

The Workers runtime is designed to be [JavaScript standards compliant](https://ecma-international.org/publications-and-standards/standards/ecma-262/) and web-interoperable. Wherever possible, it uses web platform APIs, so that code can be reused across client and server, as well as across [WinterCG](https://wintercg.org/) JavaScript runtimes.

[Workers runtime features](https://developers.cloudflare.com/workers/runtime-apis/) are [compatible with a subset of Node.js APIs](https://developers.cloudflare.com/workers/runtime-apis/nodejs) and the ability to set a [compatibility date or compatibility flag](https://developers.cloudflare.com/workers/configuration/compatibility-dates/).

* [Bindings (env)](https://developers.cloudflare.com/workers/runtime-apis/bindings/)
* [Cache](https://developers.cloudflare.com/workers/runtime-apis/cache/)
* [Console](https://developers.cloudflare.com/workers/runtime-apis/console/)
* [Context (ctx)](https://developers.cloudflare.com/workers/runtime-apis/context/)
* [Encoding](https://developers.cloudflare.com/workers/runtime-apis/encoding/)
* [EventSource](https://developers.cloudflare.com/workers/runtime-apis/eventsource/)
* [Fetch](https://developers.cloudflare.com/workers/runtime-apis/fetch/)
* [Handlers](https://developers.cloudflare.com/workers/runtime-apis/handlers/)
* [Headers](https://developers.cloudflare.com/workers/runtime-apis/headers/)
* [HTMLRewriter](https://developers.cloudflare.com/workers/runtime-apis/html-rewriter/)
* [MessageChannel](https://developers.cloudflare.com/workers/runtime-apis/messagechannel/)
* [Node.js compatibility](https://developers.cloudflare.com/workers/runtime-apis/nodejs/)
* [Performance and timers](https://developers.cloudflare.com/workers/runtime-apis/performance/)
* [Remote-procedure call (RPC)](https://developers.cloudflare.com/workers/runtime-apis/rpc/)
* [Request](https://developers.cloudflare.com/workers/runtime-apis/request/)
* [Response](https://developers.cloudflare.com/workers/runtime-apis/response/)
* [Streams](https://developers.cloudflare.com/workers/runtime-apis/streams/)
* [TCP sockets](https://developers.cloudflare.com/workers/runtime-apis/tcp-sockets/)
* [Web Crypto](https://developers.cloudflare.com/workers/runtime-apis/web-crypto/)
* [Web standards](https://developers.cloudflare.com/workers/runtime-apis/web-standards/)
* [WebAssembly (Wasm)](https://developers.cloudflare.com/workers/runtime-apis/webassembly/)
* [WebSockets](https://developers.cloudflare.com/workers/runtime-apis/websockets/)
